window.addEvent('domready',function(){
	var TextDropShadow = new Class({
		options: {
			color: '#51382e',
			left: 1,
			top: 1,
			position: 'absolute'
		},

		initialize: function(obj, options){
				this.setOptions(options)
				this.createDropShadows(obj);
		},
		
		createDropShadows: function(obj){
			if('element' == $type(obj)) {
				this.applyDropShadow(obj)
			} else if('array' == $type(obj)) {
				obj.each( function(el) {
					this.applyDropShadow(el);
				}, this);
			} else {
				return false;
			}
		},
		
		applyDropShadow: function(el){
			var original = el.clone();
			var shadow = el.clone();

			var offsetY = this.options.top ? this.options.top.toInt() : this.options.bottom.toInt();
			if(offsetY < 0) offsetY = offsetY * (-1);
			
			var offsetX = this.options.left ? this.options.left.toInt() : this.options.right.toInt();
			if(offsetX < 0) offsetX = offsetX * (-1);
			
			var container = new Element('div', {
					'styles': {
							position: 'relative',
							left: 0,
							top: el.getStyle('top'),
							height: el.getSize().y + offsetY,
							width: el.getSize().x + offsetX,
							'margin-bottom':el.getStyle('margin-bottom')
					}
			});

			original.setStyles({position: 'absolute', left: 0, top: 0,border:'none'});
			shadow.setStyles(this.options);
						
			container.adopt(shadow).adopt(original);
			container.injectAfter(el);
			el.destroy();
		}
});
TextDropShadow.implement(new Options, new Events);

var title=$$('.modul-title,h1.componentheading,h2.contentheading,.box-data .giorno,.blog_more_general h2,fieldset legend');

	title.each(function(tit){
			new TextDropShadow(tit);			
	});
	
});