<?php
/**
 * @version		$Id: blog_item.php 18936 2010-09-17 14:31:19Z infograf768 $
 * @package		Joomla.Site
 * @subpackage	com_content
 * @copyright	Copyright (C) 2005 - 2010 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;

// Create a shortcut for params.
$params = &$this->item->params;
$canEdit = $this->user->authorise('core.edit', 'com_content.category.' . $this->item->id);
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::core();

?>
<?php 
if(isset($this->item->created)){
	
   $creazione= explode(' ',JHTML::_('date', $this->item->created, JText::_('DATE_FORMAT_LC3')));
   
   $mese=substr($creazione[1],0,3);
   
}
?>
<div class="article">
<?php if ($this->item->state == 0) : ?>
<div class="system-unpublished">
<?php endif; ?>

<?php if ($params->get('show_create_date')) : ?>
		<div class="header-title">
		
  	<?php else:?>
  		<div class="header-title-withoutdate">
    <?php endif;?>
	<?php if ($params->get('show_create_date')) : ?>

		<div class="box-data">
     		 <div class="mese"> <?php echo $mese;?> </div>
     		 <div class="giorno"> <?php echo substr($creazione[0],0,2);?> </div>
     		 <div class="anno"> <?php echo substr($creazione[2],0,4);?> </div>
    	</div>
	<?php endif;?>
	<?php if ($params->get('show_title')) : ?>
	<div class="titolo-articolo">
	<h2 class="contentheading">
		<?php if ($params->get('link_titles') && $params->get('access-view')) : ?>
			<a href="<?php echo JRoute::_(ContentHelperRoute::getArticleRoute($this->item->slug, $this->item->catid)); ?>">
			<?php echo $this->escape($this->item->title); ?></a>
		<?php else : ?>
			<?php echo $this->escape($this->item->title); ?>
		<?php endif; ?>
	</h2>
	</div>
<?php endif; ?>


<?php 
if($params->get('show_modify_date')||$params->get('show_publish_date') ||($params->get('show_author') && !empty($this->item->author))||(($params->get('show_author')) or ($params->get('show_category')) or ($params->get('show_create_date')) or ($params->get('show_modify_date')) or ($params->get('show_publish_date')) or ($params->get('show_parent_category')) or ($params->get('show_hits')))||($params->get('show_print_icon') || $params->get('show_email_icon') || $canEdit) ):
?>

<div class="informazioni">
      
	  <div class="informazioni-top">
	  	
	  <?php if ($params->get('show_modify_date')) : ?>
		<span class="modified">
		<?php echo JText::sprintf('COM_CONTENT_LAST_UPDATED', JHTML::_('date',$this->item->modified, JText::_('DATE_FORMAT_LC4'))); ?>
		</span>
<?php endif; ?>
<?php if ($params->get('show_publish_date')) : ?>
		<span class="published">
		<?php echo JText::sprintf('COM_CONTENT_PUBLISHED_DATE', JHTML::_('date',$this->item->publish_up, JText::_('DATE_FORMAT_LC4'))); ?>
		</span>
<?php endif; ?>
<?php if ($params->get('show_author') && !empty($this->item->author)) : ?>
	<span class="createdby">
		<?php $author = $params->get('link_author', 0) ? JHTML::_('link',JRoute::_('index.php?option=com_users&view=profile&member_id='.$this->item->created_by),$this->item->author) : $this->item->author; ?>
		<?php $author=($this->item->created_by_alias ? $this->item->created_by_alias : $author);?>
	<?php echo JText::sprintf('COM_CONTENT_WRITTEN_BY', $author); ?>
		</span>
	<?php endif; ?>


	  </div>
	  <?php if (($params->get('show_author')) or ($params->get('show_category')) or ($params->get('show_modify_date')) or ($params->get('show_publish_date')) or ($params->get('show_parent_category')) or ($params->get('show_hits'))) : ?>

<?php endif; ?>
<?php if ($params->get('show_parent_category')) : ?>
		
			<?php $title = $this->escape($this->item->parent_title);
				  $url = '<a href="' . JRoute::_(ContentHelperRoute::getCategoryRoute($this->item->parent_slug)) . '">' . $title . '</a>'; ?>
			<?php if ($params->get('link_parent_category') AND $this->item->parent_slug) : ?>
				<span class="space"><?php echo JText::sprintf('COM_CONTENT_PARENT', $url); ?></span>
				<?php else : ?>
				<span class="space"><?php echo JText::sprintf('COM_CONTENT_PARENT', $title); ?></span>
			<?php endif; ?>
		
<?php endif; ?>
<?php if ($params->get('show_print_icon') || $params->get('show_email_icon') || $canEdit) : ?>
<div class="icone">
	
		<?php if ($params->get('show_print_icon')) : ?>
			<?php echo JHtml::_('icon.print_popup', $this->item, $params); ?>
		<?php endif; ?>
		<?php if ($params->get('show_email_icon')) : ?>
			<?php echo JHtml::_('icon.email', $this->item, $params); ?>
		<?php endif; ?>

		<?php if ($canEdit) : ?>
			<?php echo JHtml::_('icon.edit', $this->item, $params); ?>
		
		<?php endif; ?>
	</div>
<?php endif; ?>

	  
</div><!--fine div informazioni-->
<?php endif;?>	

	</div>	<!--fine blocco superiore-->

<?php if (!$params->get('show_intro')) : ?>
	<?php echo $this->item->event->afterDisplayTitle; ?>
<?php endif; ?>

 <?php if(!empty($this->item->event->beforeDisplayContent)): ?>
	<div class="before_display_content"><?php echo $this->item->event->beforeDisplayContent; ?></div>
<?php endif;?>
<?php // to do not that elegant would be nice to group the params ?>



<?php echo $this->item->introtext; ?>

<?php if ($params->get('show_readmore') && $this->item->readmore) :
	if ($params->get('access-view')) :
		$link = JRoute::_(ContentHelperRoute::getArticleRoute($this->item->slug, $this->item->catid));
	else :
		$menu = JFactory::getApplication()->getMenu();
		$active = $menu->getActive();
		$itemId = $active->id;
		$link1 = JRoute::_('index.php?option=com_users&view=login&Itemid=' . $itemId);
		$returnURL = JRoute::_(ContentHelperRoute::getArticleRoute($this->item->slug));
		$link = new JURI($link1);
		$link->setVar('return', base64_encode($returnURL));
	endif;
?>
		<div class="readmore">
				<a href="<?php echo $link; ?>">
					<?php if (!$params->get('access-view')) :
						echo JText::_('COM_CONTENT_REGISTER_TO_READ_MORE');
					elseif ($readmore = $this->item->alternative_readmore) :
						echo $readmore;
					else :
						echo JText::sprintf('COM_CONTENT_READ_MORE', $this->escape($this->item->title));
					endif; ?></a>
		</div>
<?php endif; ?>
<?php if ($params->get('show_category')) : ?>
		<div class="page-info">
			<?php $title = $this->escape($this->item->category_title);
					$url = '<a href="' . JRoute::_(ContentHelperRoute::getCategoryRoute($this->item->catid)) . '">' . $title . '</a>'; ?>
			<?php if ($params->get('link_category')) : ?>
				<?php echo JText::sprintf('COM_CONTENT_CATEGORY', $url); ?>
				<?php else : ?>
				<?php echo JText::sprintf('COM_CONTENT_CATEGORY', $title); ?>
			<?php endif; ?>
		</div>
<?php endif; ?>

<?php if ($params->get('show_hits')) : ?>
		<div class="page-info">
		<?php echo JText::sprintf('COM_CONTENT_ARTICLE_HITS', $this->item->hits); ?>
		</div>
<?php endif; ?>

<?php if ($this->item->state == 0) : ?>
</div>
<?php endif; ?>

<div class="item-separator"></div>
<?php echo $this->item->event->afterDisplayContent; ?>

</div>
